/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfString;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;

public class PdfDate
extends PdfString {
    private static final int[] DATE_SPACE = new int[]{1, 4, 0, 2, 2, -1, 5, 2, 0, 11, 2, 0, 12, 2, 0, 13, 2, 0};

    public PdfDate(Calendar d2) {
        StringBuffer date = new StringBuffer("D:");
        date.append(this.setLength(d2.get(1), 4));
        date.append(this.setLength(d2.get(2) + 1, 2));
        date.append(this.setLength(d2.get(5), 2));
        date.append(this.setLength(d2.get(11), 2));
        date.append(this.setLength(d2.get(12), 2));
        date.append(this.setLength(d2.get(13), 2));
        int timezone = (d2.get(15) + d2.get(16)) / 3600000;
        if (timezone == 0) {
            date.append('Z');
        } else if (timezone < 0) {
            date.append('-');
            timezone = -timezone;
        } else {
            date.append('+');
        }
        if (timezone != 0) {
            date.append(this.setLength(timezone, 2)).append('\'');
            int zone = Math.abs((d2.get(15) + d2.get(16)) / 60000) - timezone * 60;
            date.append(this.setLength(zone, 2)).append('\'');
        }
        this.value = date.toString();
    }

    public PdfDate() {
        this(new GregorianCalendar());
    }

    private String setLength(int i2, int length) {
        StringBuffer tmp = new StringBuffer();
        tmp.append(i2);
        while (tmp.length() < length) {
            tmp.insert(0, "0");
        }
        tmp.setLength(length);
        return tmp.toString();
    }

    public String getW3CDate() {
        return PdfDate.getW3CDate(this.value);
    }

    public static String getW3CDate(String d2) {
        if (d2.startsWith("D:")) {
            d2 = d2.substring(2);
        }
        StringBuffer sb = new StringBuffer();
        if (d2.length() < 4) {
            return "0000";
        }
        sb.append(d2.substring(0, 4));
        d2 = d2.substring(4);
        if (d2.length() < 2) {
            return sb.toString();
        }
        sb.append('-').append(d2.substring(0, 2));
        d2 = d2.substring(2);
        if (d2.length() < 2) {
            return sb.toString();
        }
        sb.append('-').append(d2.substring(0, 2));
        d2 = d2.substring(2);
        if (d2.length() < 2) {
            return sb.toString();
        }
        sb.append('T').append(d2.substring(0, 2));
        d2 = d2.substring(2);
        if (d2.length() < 2) {
            sb.append(":00Z");
            return sb.toString();
        }
        sb.append(':').append(d2.substring(0, 2));
        d2 = d2.substring(2);
        if (d2.length() < 2) {
            sb.append('Z');
            return sb.toString();
        }
        sb.append(':').append(d2.substring(0, 2));
        d2 = d2.substring(2);
        if (d2.startsWith("-") || d2.startsWith("+")) {
            String sign = d2.substring(0, 1);
            d2 = d2.substring(1);
            String h2 = "00";
            String m2 = "00";
            if (d2.length() >= 2) {
                h2 = d2.substring(0, 2);
                if (d2.length() > 2 && (d2 = d2.substring(3)).length() >= 2) {
                    m2 = d2.substring(0, 2);
                }
                sb.append(sign).append(h2).append(':').append(m2);
                return sb.toString();
            }
        }
        sb.append('Z');
        return sb.toString();
    }

    public static Calendar decode(String s) {
        try {
            GregorianCalendar calendar;
            if (s.startsWith("D:")) {
                s = s.substring(2);
            }
            int slen = s.length();
            int idx = s.indexOf(90);
            if (idx >= 0) {
                slen = idx;
                calendar = new GregorianCalendar(new SimpleTimeZone(0, "ZPDF"));
            } else {
                int sign = 1;
                idx = s.indexOf(43);
                if (idx < 0 && (idx = s.indexOf(45)) >= 0) {
                    sign = -1;
                }
                if (idx < 0) {
                    calendar = new GregorianCalendar();
                } else {
                    int offset = Integer.parseInt(s.substring(idx + 1, idx + 3)) * 60;
                    if (idx + 5 < s.length()) {
                        offset += Integer.parseInt(s.substring(idx + 4, idx + 6));
                    }
                    calendar = new GregorianCalendar(new SimpleTimeZone(offset * sign * 60000, "ZPDF"));
                    slen = idx;
                }
            }
            calendar.clear();
            idx = 0;
            for (int k2 = 0; k2 < DATE_SPACE.length && idx < slen; idx += DATE_SPACE[k2 + 1], k2 += 3) {
                calendar.set(DATE_SPACE[k2], Integer.parseInt(s.substring(idx, idx + DATE_SPACE[k2 + 1])) + DATE_SPACE[k2 + 2]);
            }
            return calendar;
        }
        catch (Exception e2) {
            return null;
        }
    }
}

